<?php
class Home extends Controller
{
    public function __construct() {
        session_start();
        if (!empty($_SESSION['activo'])) {
            header("location: ".base_url. "admin");
        }
        parent::__construct();
    }
    public function index()
    {
        $data = $this->model->getVerificar('empresa');
        $this->views->getView('home', "index", $data);
    }
    public function validar()
    {
        if (empty(strClean($_POST['usuario'])) || empty(strClean($_POST['clave']))) {
            $msg = array('msg' => "El usuario y la contraseña es requerido", 'icono' => 'warning');
        } else {
            $usuario = strClean($_POST['usuario']);
            $clave = strClean($_POST['clave']);
            $data = $this->model->getUsuario($usuario);
            if ($data != null) {
                if (password_verify($clave, $data['clave'])) {
                    $_SESSION['id_usuario'] = $data['id'];
                    $_SESSION['id_caja'] = $data['id_caja'];
                    $_SESSION['usuario'] = $data['usuario'];
                    $_SESSION['tipousuario'] = $data['tipousuario'];
                    $_SESSION['nombre'] = $data['nombre'];
                    $_SESSION['activo'] = true;
                    $_SESSION['ticket'] = true;
                    $this->verificarPermisos($data['id']);
                    $msg = array('msg' => "ok");
                } else {
                    $msg = array('msg' => "Contraseña incorrecta", 'icono' => 'error');
                }
            } else {
                $msg = array('msg' => "El usuario no existe", 'icono' => 'warning');
            }
        }
        echo json_encode($msg, JSON_UNESCAPED_UNICODE);
        die();
    }

    ## PERMISOS
    public function verificarPermisos($id_usuario)
    {
        //1.- PERMISOS ADMINISTRACIÓN
        $per_admin = $this->model->verificarPermisos($id_usuario, "administracion");
        $data['admin'] = (!empty($per_admin) || $id_usuario == 1) ? true : false;
        //2.- PERMISOS USERS
        $per_users = $this->model->verificarPermisos($id_usuario, "usuarios");
        $data['usuarios'] = (!empty($per_users) || $id_usuario == 1) ? true : false;
        //3.- PERMISOS CAJAS
        $per_caja = $this->model->verificarPermisos($id_usuario, "cajas");
        $data['cajas'] = (!empty($per_caja) || $id_usuario == 1) ? true : false;
        //4.- PERMISOS ARQUEO
        $per_arqueo = $this->model->verificarPermisos($id_usuario, "arqueo caja");
        $data['arqueo'] = (!empty($per_arqueo) || $id_usuario == 1) ? true : false;
        //5.- PERMISOS MOVIMIENTO
        $per_movi = $this->model->verificarPermisos($id_usuario, "movimientos caja");
        $data['movimiento'] = (!empty($per_movi) || $id_usuario == 1) ? true : false;
        //6.- PERMISOS MEDIDAS
        $per_med = $this->model->verificarPermisos($id_usuario, "medidas");
        $data['medidas'] = (!empty($per_med) || $id_usuario == 1) ? true : false;
        //7.- PERMISOS CATEGORIAS
        $per_cat = $this->model->verificarPermisos($id_usuario, "categorias");
        $data['categorias'] = (!empty($per_cat) || $id_usuario == 1) ? true : false;
        //8.- PERMISOS MARCAS
        $per_marc = $this->model->verificarPermisos($id_usuario, "marcas");
        $data['marcas'] = (!empty($per_marc) || $id_usuario == 1) ? true : false;
        
        //9.- PERMISOS PRODUCTOS
        //$per_pro = $this->model->verificarPermisos($id_usuario, "productos");
        //$data['productos'] = (!empty($per_pro) || $id_usuario == 1) ? true : false;
        
        //10.- PERMISOS COTIZACIONES
        $per_cot = $this->model->verificarPermisos($id_usuario, "cotizaciones");
        $data['cotizaciones'] = (!empty($per_cot) || $id_usuario == 1) ? true : false;
        //11.- PERMISOS APARTADOS
        $per_apart = $this->model->verificarPermisos($id_usuario, "apartados");
        $data['apartados'] = (!empty($per_apart) || $id_usuario == 1) ? true : false;
        //12.- PERMISOS COMPRAS
        $per_compra = $this->model->verificarPermisos($id_usuario, "compras");
        $data['compras'] = (!empty($per_compra) || $id_usuario == 1) ? true : false;
        //13.- PERMISOS VENTAS
        $per_venta = $this->model->verificarPermisos($id_usuario, "ventas1");
        $data['ventas1'] = (!empty($per_venta) || $id_usuario == 1) ? true : false;
        //14.- PERMISOS CREDITO COMPRAS
        $per_cred_com = $this->model->verificarPermisos($id_usuario, "administrar creditos compras");
        $data['credito_compra'] = (!empty($per_cred_com) || $id_usuario == 1) ? true : false;
        //15.- PERMISOS CREDITO VENTAS
        $per_cred_ven = $this->model->verificarPermisos($id_usuario, "administrar creditos ventas");
        $data['credito_venta'] = (!empty($per_cred_ven) || $id_usuario == 1) ? true : false;
        //16.- PERMISOS PDF
        $per_pdf = $this->model->verificarPermisos($id_usuario, "reportes pdf");
        $data['pdf'] = (!empty($per_pdf) || $id_usuario == 1) ? true : false;
        //17.- PERMISOS EXCEL
        $per_excel = $this->model->verificarPermisos($id_usuario, "reportes excel");
        $data['excel'] = (!empty($per_excel) || $id_usuario == 1) ? true : false;
        $_SESSION['permisos'] = $data;
        //10000- PERMISOS ESCRITORIO
        $per_escritorio = $this->model->verificarPermisos($id_usuario, "Escritorio");
        $data['escritorio'] = (!empty($per_escritorio) || $id_usuario == 1) ? true : false;
        $_SESSION['permisos'] = $data;
        //20000- PERMISOS ACTIVIDAD
        $per_actividad = $this->model->verificarPermisos($id_usuario, "Actividad");
        $data['actividad'] = (!empty($per_actividad) || $id_usuario == 1) ? true : false;
        $_SESSION['permisos'] = $data;
        //30000- PERMISOS AGENDA
        $per_agenda = $this->model->verificarPermisos($id_usuario, "Agenda");
        $data['agenda'] = (!empty($per_agenda) || $id_usuario == 1) ? true : false;
        $_SESSION['permisos'] = $data;
        //40000- PERMISOS CLIENTES
        $per_clientes = $this->model->verificarPermisos($id_usuario, "Clientes");
        $data['clientes'] = (!empty($per_clientes) || $id_usuario == 1) ? true : false;
        $_SESSION['permisos'] = $data;
        //40100- PERMISOS MANTENIMIENTO DE CLIENTES
        $per_mantenimiento_clientes = $this->model->verificarPermisos($id_usuario, "Mantenimiento de clientes");
        $data['mantenimiento de clientes'] = (!empty($per_mantenimiento_clientes) || $id_usuario == 1) ? true : false;
        $_SESSION['permisos'] = $data;
        //40110- PERMISOS CREAR CLIENTES NUEVOS
        $per_crear_clientes = $this->model->verificarPermisos($id_usuario, "Crear clientes nuevos");
        $data['crear clientes nuevos'] = (!empty($per_crear_clientes) || $id_usuario == 1) ? true : false;
        $_SESSION['permisos'] = $data;
        //40120- PERMISOS EDITAR DATOS DE CLIENTES
        $per_editar_clientes = $this->model->verificarPermisos($id_usuario, "Editar datos de Cliente");
        $data['editar datos de Cliente'] = (!empty($per_editar_clientes) || $id_usuario == 1) ? true : false;
        $_SESSION['permisos'] = $data;
        //40130- PERMISOS VER CONFIGURACION DE CLIENTES
        $per_configuracion_clientes = $this->model->verificarPermisos($id_usuario, "Ver configuracion de cliente");
        $data['ver configuracion de cliente'] = (!empty($per_configuracion_clientes) || $id_usuario == 1) ? true : false;
        $_SESSION['permisos'] = $data;
        //40140- PERMISOS ELIMINAR CLIENTE
        $per_eliminar_clientes = $this->model->verificarPermisos($id_usuario, "Eliminar cliente");
        $data['eliminar cliente'] = (!empty($per_eliminar_clientes) || $id_usuario == 1) ? true : false;
        $_SESSION['permisos'] = $data;
        //40150- PERMISOS ACCIONES DEL CLIENTE 
        $per_acciones_cliente = $this->model->verificarPermisos($id_usuario, "Acciones del cliente");
        $data['acciones del cliente'] = (!empty($per_acciones_cliente) || $id_usuario == 1) ? true : false;
        $_SESSION['permisos'] = $data;
        //40160- PERMISOS PROGRAMACIONES DEL CLIENTE 
        $per_programaciones_cliente = $this->model->verificarPermisos($id_usuario, "Programaciones del cliente");
        $data['programaciones del cliente'] = (!empty($per_programaciones_cliente) || $id_usuario == 1) ? true : false;
        $_SESSION['permisos'] = $data;
        //40170- PERMISOS ACCIONES DE VENTAS CLIENTE 
        $per_reporte_saldo_cliente = $this->model->verificarPermisos($id_usuario, "Reporte de saldo clientes");
        $data['Reporte de saldo clientes'] = (!empty($per_reporte_saldo_cliente) || $id_usuario == 1) ? true : false;
        $_SESSION['permisos'] = $data;
        //40180- PERMISOS ACCIONES DE VENTAS CLIENTE 
        $per_acciones_ventas_cliente = $this->model->verificarPermisos($id_usuario, "Acciones de ventas clientes");
        $data['Acciones de ventas clientes'] = (!empty($per_acciones_ventas_cliente) || $id_usuario == 1) ? true : false;
        $_SESSION['permisos'] = $data;
        //40190- PERMISOS CRM DEL CLIENTES 
        $per_crm_cliente = $this->model->verificarPermisos($id_usuario, "CRM del cliente");
        $data['crm del cliente'] = (!empty($per_crm_cliente) || $id_usuario == 1) ? true : false;
        $_SESSION['permisos'] = $data;

        
        //40200- PERMISOS PAGOS Y ABONOS DE CLIENTES
        $per_pago_abono_clientes = $this->model->verificarPermisos($id_usuario, "Pago y abonos de clientes");
        $data['pago y abonos de clientes'] = (!empty($per_pago_abono_clientes) || $id_usuario == 1) ? true : false;
        $_SESSION['permisos'] = $data;
        //50000- PERMISOS PRODUCTOS
        $per_productos = $this->model->verificarPermisos($id_usuario, "Productos");
        $data['productos'] = (!empty($per_productos) || $id_usuario == 1) ? true : false;
        $_SESSION['permisos'] = $data;
        //50100- PERMISOS MANTENIMIENTO DE PRODUCTOS
        $per_mantenimiento_productos = $this->model->verificarPermisos($id_usuario, "Mantenimiento de productos");
        $data['mantenimiento de productos'] = (!empty($per_mantenimiento_productos) || $id_usuario == 1) ? true : false;
        $_SESSION['permisos'] = $data;
        //50200- PERMISOS MEDIDAS DE PRODUCTOS
        $per_medidas_productos = $this->model->verificarPermisos($id_usuario, "Medidas de productos");
        $data['medidas de productos'] = (!empty($per_medidas_productos) || $id_usuario == 1) ? true : false;
        $_SESSION['permisos'] = $data;
        //50300- PERMISOS CATEGORIAS DE PRODUCTOS
        $per_categorias_productos = $this->model->verificarPermisos($id_usuario, "Categorias de productos");
        $data['categorias de productos'] = (!empty($per_categorias_productos) || $id_usuario == 1) ? true : false;
        $_SESSION['permisos'] = $data;
        //50400- PERMISOS MARCAS DE PRODUCTOS
        $per_marcas_productos = $this->model->verificarPermisos($id_usuario, "Marcas de productos");
        $data['marcas de productos'] = (!empty($per_marcas_productos) || $id_usuario == 1) ? true : false;
        $_SESSION['permisos'] = $data;
        //50500- PERMISOS INGRESO RECIENTES DE PRODUCTOS
        $per_ingresorec_productos = $this->model->verificarPermisos($id_usuario, "Ingresos recientes de productos");
        $data['ingresos recientes de productos'] = (!empty($per_ingresorec_productos) || $id_usuario == 1) ? true : false;
        $_SESSION['permisos'] = $data;
        //60000- PERMISOS VENDEDORES
        $per_vendedores = $this->model->verificarPermisos($id_usuario, "Vendedores");
        $data['vendedores'] = (!empty($per_vendedores) || $id_usuario == 1) ? true : false;
        $_SESSION['permisos'] = $data;
        //60100- PERMISOS MANTENIMIENTO DE VENDEDORES
        $per_mantenimiento_vendedores = $this->model->verificarPermisos($id_usuario, "Mantenimiento de vendedores");
        $data['mantenimiento de vendedores'] = (!empty($per_mantenimiento_vendedores) || $id_usuario == 1) ? true : false;
        $_SESSION['permisos'] = $data;
        //60200- PERMISOS RUTA VENDEDORES
        $per_ruta_vendedores = $this->model->verificarPermisos($id_usuario, "Ruta vendedores");
        $data['ruta vendedores'] = (!empty($per_ruta_vendedores) || $id_usuario == 1) ? true : false;
        $_SESSION['permisos'] = $data;
        //70000- PERMISOS VENTAS
        $per_ventas = $this->model->verificarPermisos($id_usuario, "Ventas");
        $data['ventas'] = (!empty($per_ventas) || $id_usuario == 1) ? true : false;
        $_SESSION['permisos'] = $data;
        //70100- PERMISOS COTIZACIONES DE VENTAS
        $per_cotizacion_ventas = $this->model->verificarPermisos($id_usuario, "Cotizaciones de ventas");
        $data['cotizaciones de ventas'] = (!empty($per_cotizacion_ventas) || $id_usuario == 1) ? true : false;
        $_SESSION['permisos'] = $data;
        //70200- PERMISOS PEDIDOS DE VENTAS
        $per_pedidos_ventas = $this->model->verificarPermisos($id_usuario, "Pedidos de ventas");
        $data['pedidos de ventas'] = (!empty($per_pedidos_ventas) || $id_usuario == 1) ? true : false;
        $_SESSION['permisos'] = $data;
        //70300- PERMISOS FACTURAS DE VENTAS
        $per_facturas_ventas = $this->model->verificarPermisos($id_usuario, "Facturas de ventas");
        $data['facturas de ventas'] = (!empty($per_facturas_ventas) || $id_usuario == 1) ? true : false;
        $_SESSION['permisos'] = $data;
        //70400- PERMISOS ENVIOS DE VENTAS
        $per_envios_ventas = $this->model->verificarPermisos($id_usuario, "Envios de ventas");
        $data['envios de ventas'] = (!empty($per_envios_ventas) || $id_usuario == 1) ? true : false;
        $_SESSION['permisos'] = $data;
        //70500- PERMISOS HISTORIAL DE VENTAS
        $per_historial_ventas = $this->model->verificarPermisos($id_usuario, "Historial de ventas");
        $data['historial de ventas'] = (!empty($per_historial_ventas) || $id_usuario == 1) ? true : false;
        $_SESSION['permisos'] = $data;
        //80000- PERMISOS DEVOLUCIONES
        $per_devoluciones = $this->model->verificarPermisos($id_usuario, "Devoluciones");
        $data['devoluciones'] = (!empty($per_devoluciones) || $id_usuario == 1) ? true : false;
        $_SESSION['permisos'] = $data;
         //80100- PERMISOS NOTAS DE CAMBIO DEVOLUCIONES
        $per_notas_cambio_devoluciones = $this->model->verificarPermisos($id_usuario, "Notas de cambio devoluciones");
        $data['notas de cambio devoluciones'] = (!empty($per_notas_cambio_devoluciones) || $id_usuario == 1) ? true : false;
        $_SESSION['permisos'] = $data;
         //80200- PERMISOS NOTAS DE DEVOLUCIONES
        $per_notas_devoluciones = $this->model->verificarPermisos($id_usuario, "Notas de devoluciones ");
        $data['notas de devoluciones'] = (!empty($per_notas_devoluciones) || $id_usuario == 1) ? true : false;
        $_SESSION['permisos'] = $data;

    }
}
