<?php
class PedidosModel extends Query
{
    
	public function __construct()
    {
        parent::__construct();
    }
    
	public function buscarProducto(string $cod)
    {
        $buscador='';
        $palabras= explode(' ', $cod);

        if(count($palabras)==1)
        {
            $buscador="( CONCAT(codigo,' ',descripcion) LIKE '%{$cod}%' ) AND ";
        } else if(count($palabras)>1) {
            $buscador='';
            foreach ($palabras as $key => $value) {
               //$buscador.=(($buscador2=='')?'':' AND ');
               $buscador.=(($buscador=='')?'':' AND ')." CONCAT(codigo,' ',descripcion) LIKE '%{$value}%' ";
            }
            $buscador="( {$buscador} ) AND ";
        }
        /*$sql = "SELECT * FROM productos WHERE 
            codigo LIKE '%" . $cod . "%' AND estado = 1 OR 
            descripcion LIKE '%" . $cod . "%' AND estado = 1
            LIMIT 25";*/
        $sql = "SELECT * FROM productos WHERE {$buscador} estado = 1 LIMIT 25";
        $data = $this->selectAll($sql);
        return $data;
    } 
    
	public function buscarProveedor(string $nombre)
    {
        $sql = "SELECT * FROM proveedor WHERE nombre LIKE '%" . $nombre . "%' AND estado = 1 LIMIT 10";
        $data = $this->selectAll($sql);
        return $data;
    }
    
	public function getProducto(int $id)
    {
        $sql = "SELECT * FROM productos WHERE id = $id";
        $data = $this->select($sql);
        return $data;
    }
    
	public function getDatos(string $table, int $id)
    {
        $sql = "SELECT * FROM $table WHERE id = $id";
        $data = $this->select($sql);
        return $data;
    }
    
	public function registrarDetalle(int $id_producto, int $id_usuario, string $precio, int $cantidad, string $sub_total)
    {
        $sql = "INSERT INTO detalle_temp (id_producto, id_usuario, precio, cantidad, sub_total) VALUES (?,?,?,?,?)";
        $datos = array($id_producto, $id_usuario, $precio, $cantidad, $sub_total);
        $data = $this->save($sql, $datos);
        if ($data == 1) {
            $res = "ok";
        } else {
            $res = "error";
        }
        return $res;
    }

    /*
    public function registrarToken(string $token,string $vigencia,int $sucursal)
    {
        $sql = "UPDATE `ws_token` SET `activo`=0  WHERE `sucursal`='{$sucursal}'";
        $datos = array();
        $data = $this->save($sql,$datos);

        $fecha_vigencia=date( 'Y-m-d h:i:s', strtotime( '-6 hours', strtotime( $vigencia )));

        $sql = "INSERT INTO `ws_token`( `activo`, `token`, `vigencia`, `sucursal`) VALUES (1,?,?,?)";
        $datos = array($token,$fecha_vigencia,$sucursal);
        $data = $this->save($sql, $datos);
        if ($data == 1) {
            $res = "ok";
        } else {
            $res = "error";
        }
        return $res;
    }
    */


	public function getDetalle(int $id, string $table)
    {
        $sql = "SELECT d.*, p.descripcion, p.foto, p.precio_venta FROM $table d 
                INNER JOIN productos p ON d.id_producto = p.id WHERE d.id_usuario = $id";
        $data = $this->selectAll($sql);
        return $data;
    }
    
	public function getSeries()
    {
        $sql = "SELECT iduser, user FROM ws_users ";
        $data = $this->selectAll($sql);
        return $data;
    }

	public function getVendedores()
    {
        $sql = "SELECT codven, nombre FROM vendedores ";
        $data = $this->selectAll($sql);
        return $data;
    }
    
	public function getComprobar(int $id, int $usuario, string $table)
    {
        $sql = "SELECT * FROM $table WHERE id_producto = $id AND id_usuario = $usuario";
        $data = $this->select($sql);
        return $data;
    }
    
	public function calcularTotal(int $id_usuario, string $table)
    {
        $sql = "SELECT SUM(sub_total) AS total FROM $table WHERE id_usuario = $id_usuario";
        $data = $this->select($sql);
        return $data;
    }
    
	public function calcularDescuento(int $folio)
    {
        $sql = "SELECT SUM(descuento) AS total FROM detalle_ventas WHERE folio = $folio";
        $data = $this->select($sql);
        return $data;
    }
    
	public function deleteDetalle(int $id, string $table)
    {
        $sql = "DELETE FROM $table WHERE id = ?";
        $datos = array($id);
        $data = $this->save($sql, $datos);
        if ($data == 1) {
            $res = "ok";
        } else {
            $res = "error";
        }
        return $res;
    }
    
	public function insertarVenta(int $id, string $total, int $id_cliente, string $fecha, string $hora, int $forma, int $serie, string $anotacion,int $vendedor,string $tipodoc)
    {
        $sql = "INSERT INTO ventas (id_usuario, total, id_cliente, fecha, hora, forma_pago,serie,anotacion,id_vendedor,tipodoc) VALUES (?,?,?,?,?,?,?,?,?,?)";
        $datos = array($id, $total, $id_cliente, $fecha, $hora, $forma, $serie,$anotacion,$vendedor,$tipodoc);
        $data = $this->insertar($sql, $datos);
        if ($data > 0) {
            $res = $data;
        } else {
            $res = 0;
        }
        return $res;
    }

    public function getTipoDoc(int $serie)
    {
        $sql = "SELECT `tipo_fact` FROM `ws_users` WHERE `iduser`='{$serie}' LIMIT 1";
        $data = $this->select($sql);
        return $data['tipo_fact'];
    }

	public function actualizarDescripciones(int $folio)
    {
        $sql = "UPDATE `productos`,`detalle_ventas` 
        SET `detalle_ventas`.`descripcion`=`productos`.`descripcion`
        WHERE `productos`.`id`=`detalle_ventas`.`id_producto`
        AND `detalle_ventas`.`folio`=?";

        $datos = array($folio);
        $this->save($sql, $datos);
    }
    
	public function actualizarTotalesImpuestosDetalle(int $folio)
    {
        $sql = "UPDATE `detalle_ventas` 
        SET 
        `total`=(`precio`-`descuento`)*`cantidad`
        ,`mgravable`=`total`/1.12
        ,`iva`=`total`-(`total`/1.12)
        WHERE `folio`=?";

/*        $sql = "UPDATE `productos`,`detalle_ventas` 
        SET `detalle_ventas`.`descripcion`=`productos`.`descripcion`
        ,`detalle_ventas`.`total`=(`detalle_ventas`.`precio`-`detalle_ventas`.`descuento`)*`detalle_ventas`.`cantidad`
        ,`detalle_ventas`.`mgravable`=`detalle_ventas`.`total`/1.12
        ,`detalle_ventas`.`iva`=`detalle_ventas`.`total`-(`detalle_ventas`.`total`/1.12)
        WHERE `productos`.`id`=`detalle_ventas`.`id_producto` AND `detalle_ventas`.`folio`=?";*/
        $datos = array($folio);
        $this->save($sql, $datos);
    }

	public function actualizarClienteVenta(int $folio)
    {
        $sql = "UPDATE `ventas`,`clientes` 
        SET 
        `ventas`.`nitcliente`=`clientes`.`nit`
        ,`ventas`.`tipoid`=`clientes`.`tipoid`        
        ,`ventas`.`nomcliente`=`clientes`.`nombre`
        ,`ventas`.`direccion`=`clientes`.`direccion`
        ,`ventas`.`municipio`=`clientes`.`municipio`
        ,`ventas`.`departamento`=`clientes`.`departamento`
        ,`ventas`.`cpostal`=`clientes`.`cpostal`
        WHERE `ventas`.`id_cliente`=`clientes`.`id` AND `ventas`.`id`=?";
        $datos = array($folio);
        $this->save($sql, $datos);
    }

	public function actualizarClienteVentaMostrador(int $folio, string $nombre_cliente, int $tipoid, string $nit, string $direccion)
    {
        $sql = "UPDATE `ventas` 
        SET 
        `nomcliente`=?,
        `tipoid`=?,
        `nitcliente`=?,
        `direccion`=?
        WHERE `id`=?";
        $datos = array( $nombre_cliente, $tipoid, $nit, $direccion, $folio );
        $this->save($sql, $datos);
    }

	public function actualizarUltimaFechaVenta(int $id_cliente)
    {
        $sql = "UPDATE clientes SET ultimaventa = NOW() WHERE id = ?";
        $datos = array($id_cliente);
        $this->save($sql, $datos);
    }
    
	public function insertarCredito(int $id, string $total, int $id_cliente, string $fecha, int $id_usuario)
    {
        $sql = "INSERT INTO creditos (venta, monto, cliente,fecha, id_usuario) VALUES (?,?,?,?,?)";
        $datos = array($id, $total, $id_cliente, $fecha, $id_usuario);
        $data = $this->save($sql, $datos);
        if ($data == 1) {
            $res = "ok";
        } else {
            $res = "error";
        }
        return $res;
    }
    
	public function registrarDetalles(int $id, int $id_pro, string $cantidad, string $descuento, string $precio, string $sub_total)
    {
        $sql = "INSERT INTO detalle_compra (folio, id_producto, cantidad, descuento, precio, sub_total) VALUES (?,?,?,?,?,?)";
        $datos = array($id, $id_pro, $cantidad, $descuento, $precio, $sub_total);
        $data = $this->save($sql, $datos);
        if ($data == 1) {
            $res = "ok";
        } else {
            $res = "error";
        }
        return $res;
    }
    
	public function registrar(string $table,int $id, int $id_pro, string $cantidad, string $descuento, string $precio, string $sub_total)
    {
        $sql = "INSERT INTO $table (folio, id_producto, cantidad, descuento, precio ,sub_total ,total ,mgravable ,iva ) VALUES (?,?,?,?,?,? ,?,?,?)";
        
        $total=($precio-$descuento)*$cantidad;
        $mgravable=$total/1.12;
        $iva=$total-$mgravable;

        $datos = array($id, $id_pro, $cantidad, $descuento, $precio, $sub_total ,$total, $mgravable,$iva);
        $data = $this->save($sql, $datos);
        if ($data == 1) {
            $res = "ok";
        } else {
            $res = "error";
        }
        return $res;
    }
    
	public function verificarStock(string $table, int $id)
    {
        $sql = "SELECT d.id, d.id_producto, p.id, p.cantidad FROM $table d INNER JOIN productos p ON p.id = d.id_producto WHERE d.id = $id";
        $data = $this->select($sql);
        return $data;
    }
    
	public function eliminarTemp(int $id_usuario, string $table)
    {
        $sql = "DELETE FROM $table WHERE id_usuario = ?";
        $datos = array($id_usuario);
        $data = $this->save($sql, $datos);
        if ($data == 1) {
            $msg = 'ok';
        }else{
            $msg = 'error';
        }
        return $msg;
    }
    
	public function getEmpresa()
    {
        $sql = "SELECT * FROM empresa";
        $data = $this->select($sql);
        return $data;
    }
    
	public function getVentas(int $id_usuario)
    {
        $sql = "SELECT v.*, c.nombre FROM compras c INNER JOIN clientes c ON v.id_cliente = c.id WHERE v.id_usuario = $id_usuario";
        $data = $this->selectAll($sql);
        return $data;
    }

   	public function getDetalleVenta(string $table, int $id)
    {
        $sql = "SELECT * FROM $table WHERE folio = $id";
        $data = $this->selectAll($sql);
        return $data;
    }


	public function getSucursal(int $numdoc)
    {
        $sql = "SELECT * FROM `ws_users` WHERE iduser IN (SELECT serie FROM `ventas` WHERE `id`='{$numdoc}')";
        $data = $this->select($sql);
        return $data;
    }

	public function getSucursalID(int $sucursal)
    {
        $sql = "SELECT * FROM `ws_users` WHERE iduser='{$sucursal}'";
        $data = $this->select($sql);
        return $data;
    }

	public function getHistorial_ss(string $table, int $id_usuario)
    {


        $sql = "SELECT tipousuario,codigo_vendedor FROM usuarios WHERE id = $id_usuario";
        $tipo = $this->select($sql);
        $codigo_vendedor=$tipo['codigo_vendedor'];

        $columns=array('enc_num','enc_cliente', 'enc_nom','enc_fecha','enc_total','enc_tipo','enc_estado','enc_vend','facturado');
        $columnsSearch=array('enc_num','enc_cliente', 'enc_nom');

        $limit = $this->getLimitDatatable();
        $order = $this->getOrderDatatable($columns);
        $search = $this->getSearchDatatable($columnsSearch);
        $binds = $this->getBindsDatatable($columnsSearch);

        if($_GET['fecha_desde']!='' && $_GET['fecha_hasta']!='')
        {
            $search.=" AND enc_fecha  BETWEEN '{$_GET['fecha_desde']} 00:00:00' AND '{$_GET['fecha_hasta']} 23:59:00' ";
        }
        if($_GET['estados']!='')
        {
            $search.=" AND enc_estado='{$_GET['estados']}' ";
        }        

        if($_GET['tipo']!='')
        {
            $search.=" AND enc_tipo='{$_GET['tipo']}' ";
        }

        if($tipo['tipousuario'] == 3) {       
            $sql = "SELECT SQL_CALC_FOUND_ROWS 
                enc_num as id,
                TRIM(enc_cliente) as codcliente,
                enc_nom as nombre,
                enc_fecha as fecha,
                enc_total as total,
                enc_tipo as tipo,
                enc_estado,
                enc_vend as vendedor,
                facturado
                FROM `".prefixant."`.`docsenc` WHERE enc_estado != 'C' AND enc_codven = $codigo_vendedor {$search} {$order} {$limit}";
        } else {
            $sql = "SELECT SQL_CALC_FOUND_ROWS 
                enc_num as id,
                TRIM(enc_cliente) as codcliente,
                enc_nom as nombre,
                enc_fecha as fecha,
                enc_total as total,
                enc_tipo as tipo,
                enc_estado,
                enc_vend as vendedor,
                facturado
                FROM `".prefixant."`.`docsenc` WHERE enc_estado != 'C' AND 1=1 {$search} {$order} {$limit}";
        }


        $data = $this->selectAllBind($sql,PDO::FETCH_NUM,$binds);
        $TotalRecords = $this->getTotalRecordsDatatable();

        /*$total=0;
        if(count($binds)>0)
        {
            $total = $this->selectBinds("SELECT SUM(`total`) as total FROM `vista_vales` WHERE 1=1 {$search}",PDO::FETCH_ASSOC,$binds);
        } else {
            $total = $this->select("SELECT SUM(`total`) as total FROM `vista_vales` WHERE 1=1 {$search}");
        }*/

		$output = array(
			"sEcho" => intval($_GET['sEcho']),
			"iTotalRecords" => count($data),
			"iTotalDisplayRecords" => $TotalRecords,
			"aaData" => $data,
            //"total" => $total['total'],
		);        
        
        //file_put_contents('./request_log2.txt', var_export($output,true));

        return $output;

    }



	public function modificarEstadoPedido(int $id, string $estado)
    {
        $sql = "UPDATE `".prefixant."`.`docsenc` SET enc_estado = ? WHERE enc_num = ?";
        $datos = array($estado, $id);
        $this->save($sql, $datos);
    }

	public function modificarTipoPedido(int $id, string $tipo)
    {
        $sql = "UPDATE `".prefixant."`.`docsenc` SET enc_tipo = ? WHERE enc_num = ?";
        $datos = array($tipo, $id);
        $this->save($sql, $datos);
    }

	public function getPedido(int $id_pedido)
    {
        $sql = "SELECT * FROM `".prefixant."`.`docsenc` WHERE enc_num = $id_pedido";
        $data = $this->select($sql);

        $sql = "SELECT * FROM `".prefixant."`.`docsdet` WHERE det_num = $id_pedido ORDER BY det_orden ASC";
        $data['detalle'] = $this->selectAll($sql);
        
        return $data;
    }

	public function getClientePedido(int $id_pedido)
    {
        $sql = "SELECT docsenc.enc_cliente,clientes.id FROM `".prefixant."`.`docsenc`,`clientes` WHERE enc_num = $id_pedido AND docsenc.enc_cliente=clientes.codigo";
        $data = $this->select($sql);
        
        return $data;
    }

    
	public function getHistorial(string $table, int $id_usuario)
    {
        /*$sql = "SELECT c.id, c.nombre, v.*,
        (SELECT user FROM `ws_users` WHERE v.`serie`=`ws_users`.`iduser`) as sucursal,
        (SELECT `vendedores`.`nombre` FROM `vendedores` WHERE v.`id_vendedor`=`vendedores`.`codven`) as vendedor
        FROM clientes c INNER JOIN $table v ON v.id_cliente = c.id 
        WHERE v.id_usuario = $id_usuario";*/

   /*     if ($id_usuario<=100)
        {
            $sql = "SELECT v.`nomcliente` as nombre, v.*,
            (SELECT concat('[',iduser,'] - ',user) FROM `ws_users` WHERE v.`serie`=`ws_users`.`iduser`) as sucursal,
            (SELECT `vendedores`.`nombre` FROM `vendedores` WHERE v.`id_vendedor`=`vendedores`.`codven`) as vendedor
            FROM $table v";        
        } else
        {
        $sql = "SELECT v.`nomcliente` as nombre, v.*,
        (SELECT concat('[',iduser,'] - ',user) FROM `ws_users` WHERE v.`serie`=`ws_users`.`iduser`) as sucursal,
        (SELECT `vendedores`.`nombre` FROM `vendedores` WHERE v.`id_vendedor`=`vendedores`.`codven`) as vendedor
        FROM $table v  
        WHERE v.id_usuario = $id_usuario";        
        }
*/

        /*$sql = "SELECT numdoc as id,nomcliente as nombre,total,fechadoc as fecha,1 as forma_pago,1 as estado,autorizacion,
          '1' as sucursal,codven as vendedor,1 as id_vendedor
          FROM `".prefixant."`.`facturaenc` LIMIT 5";*/

        $sql = "SELECT numdoc as id,nomcliente as nombre,codcliente,total,fechadoc as fecha,1 as forma_pago,estado,autorizacion,
          '1' as sucursal,codven as vendedor,1 as id_vendedor
          FROM `".prefixant."`.`facturaenc`";


        //$sql = "SELECT v.`nomcliente` as nombre, v.id, v.total, v.fecha, v.forma_pago, v.estado, v.autorizacion, 
        //(SELECT concat('[',iduser,'] - ',user) FROM `ws_users` WHERE v.`serie`=`ws_users`.`iduser`) as sucursal,
        //(SELECT `vendedores`.`nombre` FROM `vendedores` WHERE v.`id_vendedor`=`vendedores`.`codven`) as vendedor
        //FROM $table v  LIMIT 5";        


        $data = $this->selectAll($sql);
        return $data;

    }
    
   
   /*
	public function getTokenActivo(int $sucursal)
    {
        $sql = "SELECT * FROM `ws_token` WHERE `activo`=1 AND `sucursal`='{$sucursal}'";
        $data = $this->select($sql);
        return $data;
    }
    */

    /*
	public function insertarXML_FCAM(int $folio, string $fecha, string $xml, string $errores)
    {
        $sql = "DELETE FROM `xmlfel_fcam` WHERE `numdoc` = ?";
        $datos = array($folio);
        $this->save($sql, $datos);

        $sql = "INSERT INTO `xmlfel_fcam` (`numdoc`, `fechaemision`, `xml`, `errores`) VALUES (?,?,?,?)";
        $datos = array($folio, $fecha, $xml, $errores);
        $this->save($sql, $datos);
    }
    */

    /*
	public function actualizarFacturaVentasFEL(int $folio, string $serial, string $number, string $autorizacion, string $fecha, string $uuid_firma, string $uuid_registro)
    {
        $sql = "UPDATE ventas SET seriefel = ? ,numfel = ? ,autorizacion = ? ,fechaproc = ? ,id_firma = ? ,id_registra = ? WHERE id = ?";
        $datos = array($serial,$number,$autorizacion,$fecha,$uuid_firma,$uuid_registro,$folio);
        $this->save($sql, $datos);
    }
    */

	public function actualizarProductosFechaCompra(int $folio)
    {
        $sql = "UPDATE productos SET ultimaventa=(SELECT fecha FROM `ventas` WHERE `id`=?) WHERE id IN (SELECT id_producto FROM `detalle_ventas` WHERE `folio`=?)";
        $datos = array($folio,$folio);
        $this->save($sql, $datos);
    }


    //UPDATE productos SET ultimaventa=(SELECT fecha FROM `ventas` WHERE `id`=1017) WHERE id IN (SELECT id_producto FROM `detalle_ventas` WHERE `folio`=1017)

    public function actualizarStock(int $cantidad, int $id)
    {
        $sql = "UPDATE productos SET cantidad = ? WHERE id = ?";
        $datos = array($cantidad, $id);
        $this->save($sql, $datos);
    }
    
	public function anular(string $table, int $id, string $uuid, string $fecha)
    {
        $sql = "UPDATE $table SET estado = ?, id_anula=?, fechaanul=? WHERE id = ?";
        $datos = array(0, $uuid, $fecha ,$id);
        $data = $this->save($sql, $datos);
        if ($data == 1) {
            $res = "ok";
        } else {
            $res = "error";
        }
        return $res;
    }
    
	public function anularCredito(string $table, int $id)
    {
        $sql = "UPDATE $table SET estado = ? WHERE venta = ?";
        $datos = array(2, $id);
        $data = $this->save($sql, $datos);
        if ($data == 1) {
            $res = "ok";
        } else {
            $res = "error";
        }
        return $res;
    }
    
	public function actualizarEstado(string $table, int $estado, int $id)
    {
        $sql = "UPDATE $table SET estado = ? WHERE id = ?";
        $datos = array($estado, $id);
        $data = $this->save($sql, $datos);
        if ($data == 1) {
            if ($estado == 0) {
                $res = "ok";
            }else{
                $res = "rechazado";
            }
        } else {
            $res = "error";
        }
        return $res;
    }

	public function actualizarCantidad(string $table, string $cant, int $id)
    {
        $sql = "SELECT * FROM $table WHERE id = $id";
        $data = $this->select($sql);
        $sub_total = ($cant * $data['precio']) - $data['descuento'];
        $sql = "UPDATE $table SET cantidad = ?, sub_total = ? WHERE id = ?";
        $datos = array($cant, $sub_total, $id);
        $data = $this->save($sql, $datos);
        if ($data == 1) {
            $res = "ok";
        } else {
            $res = "error";
        }
        return $res;
    }

    public function actualizarPrecio(string $table, string $precio, int $id)
    {
        $sql = "SELECT * FROM $table WHERE id = $id";
        $data = $this->select($sql);
        $sub_total = ($data['cantidad'] * $precio) - $data['descuento'];
        $sql = "UPDATE $table SET precio = ?, sub_total = ? WHERE id = ?";
        $datos = array($precio, $sub_total, $id);
        $data = $this->save($sql, $datos);
        $data=1;
        if ($data == 1) {
            $res = "ok";
        } else {
            $res = "error";
        }
        return $res;
    }

	public function actualizarDescuento(string $table, string $desc, int $id)
    {
        $sql = "SELECT * FROM $table WHERE id = $id";
        $data = $this->select($sql);
        $sub_total = ($data['cantidad'] * $data['precio']) - $desc;
        $sql = "UPDATE $table SET descuento = ?, sub_total = ? WHERE id = ?";
        $datos = array($desc, $sub_total ,$id);
        $data = $this->save($sql, $datos);
        if ($data == 1) {
            $res = "ok";
        } else {
            $res = "error";
        }
        return $res;
    }
    
	public function getVenta(int $id)
    {

        //FROM `".prefixant."`.`facturaenc`
        //$sql = "SELECT v.*, c.nombre, c.telefono, c.direccion, c.nit FROM ventas v INNER JOIN clientes c ON v.id_cliente = c.id WHERE v.id = $id";

        $sql = "SELECT * FROM `".prefixant."`.`facturaenc` WHERE numdoc = $id";
        $data = $this->select($sql);

//        if($data===false)
//        {
//            $sql = "SELECT *, nomcliente as nombre, '' as telefono, direccion, nitcliente as nit FROM ventas WHERE id = $id";
//            $data = $this->select($sql);
//            $data['id_cliente']=1;
//        }

        return $data;
    }
    
	public function detalleVentas(int $id)
    {
        //$sql = "SELECT v.*, d.*, p.cantidad AS stock, p.descripcion, p.codigo FROM ventas v INNER JOIN detalle_ventas d ON v.id = d.folio INNER JOIN productos p ON p.id = d.id_producto WHERE v.id = $folio";
        
        $sql = "SELECT * FROM `".prefixant."`.`facturadet` WHERE numdoc = $id";

        $data = $this->selectAll($sql);
        return $data;
    }

    

	public function verficarCaja(int $id)
    {
        $sql = "SELECT * FROM cajas_cierre WHERE id_usuario = $id AND estado = 1";
        $data = $this->select($sql);
        return $data;
    }
}
