<?php include "Views/templates/header.php"; ?>
<div class="card">
    <div class="card-header">
        <?php if ($data['titulo'] != 'prestamos') { ?>
            <a href="<?php echo base_url; ?>cajas/movimiento/prestamos" class="btn btn-outline-info">
                <i class="fas fa-money-bill-alt"></i>
                Historial Prestamos
            </a>
        <?php }
        if ($data['titulo'] != 'gastos') { ?>
            <a href="<?php echo base_url; ?>cajas/movimiento/gastos" class="btn btn-outline-danger">
                <i class="fas fa-money-bill"></i>
                Historial Gastos
            </a>
        <?php }
        if ($data['titulo'] != 'devolucion') { ?>
            <a href="<?php echo base_url; ?>cajas/movimiento/devolucion" class="btn btn-outline-warning">
                <i class="fas fa-money-check-alt"></i>
                Historial Devoluciones
            </a>
        <?php }
        if (!empty($data['verificar'])) { ?>
        <div class="dropdown d-inline">
            <button class="btn btn-outline-dark dropdown-toggle" type="button" id="dropdownMenuButton" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                Movimiento de Caja
            </button>
            <div class="dropdown-menu" aria-labelledby="dropdownMenuButton">
                <a class="dropdown-item" name="prestamos" href="#" onclick="frmMovimiento_caja(event)"><i class="fas fa-money-bill-alt"></i> Prestamos</a>
                <hr>
                <a class="dropdown-item" name="gastos" href="#" onclick="frmMovimiento_caja(event)"><i class="fas fa-money-bill"></i> Gastos</a>
                <hr>
                <a class="dropdown-item" name="devolucion" href="#" onclick="frmMovimiento_caja(event)"><i class="fas fa-money-check-alt"></i> Devolución</a>
            </div>
        </div>
        <?php } if (!empty($data['titulo'])) { ?>
            <a class="btn btn-outline-primary" href="<?php echo base_url; ?>cajas/movimiento"><i class="fas fa-chart-pie"></i> Ver Gráfico</a>
        <?php } ?>
    </div>
    <?php if (empty($data['titulo'])) { ?>
        <div class="card-body">
            <div class="row">
                <div class="col-md-5">
                    <table class="table table-bordered">
                        <tbody>
                            <tr>
                                <td>
                                    <i class="fas fa-check-circle text-primary"></i> MONTO INICIAL
                                    <span class="badge badge-primary float-right" id="monto_inicial">
                                    </span>
                                </td>
                            </tr>
                            <tr>
                                <td>
                                    <i class="fas fa-check-circle text-success"></i> INGRESOS
                                    <span class="badge badge-success float-right" id="monto_final">
                                    </span>
                                </td>
                            </tr>
                            <tr>
                                <td>
                                    <i class="fas fa-check-circle text-danger"></i> DEVOLUCIONES
                                    <span class="badge badge-danger float-right" id="devolucion">
                                    </span>
                                </td>
                            </tr>
                            <tr>
                                <td>
                                    <i class="fas fa-check-circle text-warning"></i> PRÉSTAMOS
                                    <span class="badge badge-warning float-right" id="prestamo">
                                    </span>
                                </td>
                            </tr>
                            <tr>
                                <td>
                                    <i class="fas fa-check-circle"></i> GASTOS
                                    <span class="badge badge-dark float-right" id="gasto">
                                    </span>
                                </td>
                            </tr>
                            <tr>
                                <td class="font-weight-bold">
                                    <i class="fas fa-check-square text-info"></i> EGRESOS TOTALES
                                    <span class="badge badge-info float-right" id="egresos">
                                    </span>
                                </td>
                            </tr>
                            <tr>
                                <td class="font-weight-bold">
                                    <i class="fas fa-check-square text-primary"></i> SALDO
                                    <span class="badge badge-primary float-right" id="saldo">
                                    </span>
                                </td>
                            </tr>
                            <tr>
                                <td class="font-weight-bold">
                                    <i class="fas fa-check-square text-purple"></i> MONTO INICIAL + SALDO
                                    <span class="badge bg-purple float-right" id="total">
                                    </span>
                                </td>
                            </tr>
                            <tr>
                                <td><a class="btn btn-outline-danger btn-block" target="_blank" href="<?php echo base_url; ?>cajas/reportePdf"><i class="fas fa-file-pdf"></i></a></td>
                            </tr>
                        </tbody>
                    </table>
                </div>
                <div class="col-md-5 ml-auto">
                    <canvas id="reporte_movimiento"></canvas>
                </div>
            </div>
        </div>
    <?php } ?>
</div>
<?php if ($data['titulo'] != '') { ?>
    <div class="card">
        <div class="card-header text-uppercase">
            <?php echo $data['titulo']; ?>
        </div>
        <div class="card-body">
            <div class="row">
                <div class="col-md-4">
                    <label for="">Desde</label>
                    <input class="form-control" id="min" type="date" name="<?php echo $data['titulo'] ?>_desde">
                </div>
                <div class="col-md-4">
                    <label for="">Hasta</label>
                    <input class="form-control" id="max" type="date" name="<?php echo $data['titulo'] ?>_hasta">
                </div>
                <div class="col-md-4">
                    <div class="form-group">
                        <label for="">Registros</label><br>
                        <button name="<?php echo $data['titulo']; ?>" class="btn btn-outline-primary btn-block" type="button" onclick="mostrarTodo(event)">Mostrar Todo</button>
                    </div>
                </div>
            </div>
            <div class="table-responsive">
                <table class="table table-hover display responsive nowrap" id="t_<?php echo $data['titulo']; ?>" style="width: 100%;">
                    <thead>
                        <tr>
                            <th>Id</th>
                            <th>Descripción</th>
                            <th>Monto</th>
                            <th>Fecha</th>
                            <th>Hora</th>
                        </tr>
                    </thead>
                    <tbody>
                    </tbody>
                    <tfoot>
                        <tr>
                            <td></td>
                            <td></td>
                            <td></td>
                            <td></td>
                            <td></td>
                        </tr>
                    </tfoot>
                </table>
            </div>
        </div>
    </div>
<?php } ?>
<div id="movimientos_caja" class="modal fade" tabindex="-1" role="dialog" aria-labelledby="my-modal-title" aria-hidden="true">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header bg-primary">
                <h5 class="modal-title" id="title_movimiento">Title</h5>
                <button class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <form id="frmMovimiento" onsubmit="registrarMovimiento(event)" autocomplete="off">
                <div class="modal-body">
                    <svg xmlns="http://www.w3.org/2000/svg" style="display: none;">
                        <symbol id="check-circle-fill" fill="currentColor" viewBox="0 0 16 16">
                            <path d="M16 8A8 8 0 1 1 0 8a8 8 0 0 1 16 0zm-3.97-3.03a.75.75 0 0 0-1.08.022L7.477 9.417 5.384 7.323a.75.75 0 0 0-1.06 1.06L6.97 11.03a.75.75 0 0 0 1.079-.02l3.992-4.99a.75.75 0 0 0-.01-1.05z" />
                        </symbol>
                        <symbol id="info-fill" fill="currentColor" viewBox="0 0 16 16">
                            <path d="M8 16A8 8 0 1 0 8 0a8 8 0 0 0 0 16zm.93-9.412-1 4.705c-.07.34.029.533.304.533.194 0 .487-.07.686-.246l-.088.416c-.287.346-.92.598-1.465.598-.703 0-1.002-.422-.808-1.319l.738-3.468c.064-.293.006-.399-.287-.47l-.451-.081.082-.381 2.29-.287zM8 5.5a1 1 0 1 1 0-2 1 1 0 0 1 0 2z" />
                        </symbol>
                        <symbol id="exclamation-triangle-fill" fill="currentColor" viewBox="0 0 16 16">
                            <path d="M8.982 1.566a1.13 1.13 0 0 0-1.96 0L.165 13.233c-.457.778.091 1.767.98 1.767h13.713c.889 0 1.438-.99.98-1.767L8.982 1.566zM8 5c.535 0 .954.462.9.995l-.35 3.507a.552.552 0 0 1-1.1 0L7.1 5.995A.905.905 0 0 1 8 5zm.002 6a1 1 0 1 1 0 2 1 1 0 0 1 0-2z" />
                        </symbol>
                    </svg>
                    <div class="alert alert-info d-flex align-items-center" role="alert">
                        <svg class="bi flex-shrink-0 me-2" width="24" height="24" role="img" aria-label="Info:">
                            <use xlink:href="#info-fill" />
                        </svg>
                        <div class="ml-2">
                            Todo los campos con <span class="text-danger fw-bold">*</span> son obligatorios.
                        </div>
                    </div>
                    <div class="form-group">
                        <label for="monto">Monto <span class="text-danger">*</span></label>
                        <input type="hidden" name="accion" id="accion">
                        <input id="monto" class="form-control" type="text" name="monto" placeholder="Monto" required>
                    </div>
                    <div class="form-group">
                        <label for="descripcion">Descripción de Movimiento <span class="text-danger">*</span></label>
                        <textarea id="descripcion" class="form-control" name="descripcion" rows="3" placeholder="Descripción" required></textarea>
                    </div>
                </div>
                <div class="modal-footer">
                    <button class="btn btn-outline-primary" type="submit">Guardar</button>
                    <button class="btn btn-outline-danger" type="button" data-dismiss="modal">Cancelar</button>
                </div>
            </form>
        </div>
    </div>
</div>
<?php include "Views/templates/footer.php"; ?>