let t_h_v;

let active_row=false;
let active_obj=false;

let fecha_min = document.getElementById('min');
let fecha_max = document.getElementById('max');
let estados = document.getElementById('estados');

document.addEventListener('DOMContentLoaded', function () {

    t_h_v = $('#t_ventas').DataTable({

        "processing": true,
        "serverSide": true,
        "deferRender" : true,
        "sAjaxSource": "" + base_url + 'ventas/listar_ventas_ss',

        "fnServerParams": function ( aoData ) {
            aoData.push( { "name": "fecha_desde", "value": fecha_min.value},
                         { "name": "fecha_hasta", "value": fecha_max.value},
                         { "name": "estados", "value": estados.value},
                        )
        },

        "type": 'POST',

        "columnDefs": [

            {   
                responsivePriority: 30000, 
                targets: -2, 
            },
            { responsivePriority: 30000, targets: -1 },
        ],
        "drawCallback": function () {
                let api = this.api();

                /*$(api.columns(2).footer()).html(
                    formatMoneyGTQ(Number(api.ajax.json().total).toFixed(2))
                )*/
                //total_ventas.innerHTML = '<strong>TOTAL VENTAS:</strong> '+ formatMoneyGTQ(Number(api.ajax.json().total).toFixed(2));

            },
        "dom": "<'row'<'col-sm-4'l><'col-sm-4 text-center'B><'col-sm-4'f>>" +
            "<'row'<'col-sm-12'tr>>" +
            "<'row'<'col-sm-5'i><'col-sm-7'p>>",
        buttons,
        language,
        "resonsieve": true,
        "responsive": true,
        "bDestroy": true,
        "iDisplayLength": 10,
        "order": [
            [0, "desc"]
        ],


    });

    t_h_v.on( 'draw', function () {
        $('#t_ventas tbody tr').removeClass('selected');
        activo_buttons(false)
    } );

    $('#t_ventas tbody').on( 'click', 'tr', function (e) {
        let classList = e.currentTarget.classList;
       
        if (classList.contains('selected')) {
            classList.remove('selected');
        }
        else {
           t_h_v.rows('.selected').nodes().each((row) => row.classList.remove('selected'));
            classList.add('selected');
        }
        activo_buttons( t_h_v.row( this ).data()  );
    } );

    fecha_min.onchange = function () { t_h_v.draw(); }
    fecha_max.onchange = function () { t_h_v.draw(); }
    estados.onchange = function () { t_h_v.draw(); }

    function activo_buttons(obj)
    {
        active_obj=obj;
        active_row=active_obj[0];

        if($('#t_ventas tbody tr.selected').length==0)
        {
            $('BUTTON.btn-toolbar-status').attr('disabled', 'disabled');
            $('BUTTON.btn-recuperar').hide();
            $('BUTTON.btn-eliminar').show();            
        } else {
            $('BUTTON.btn-toolbar-status').removeAttr('disabled');
            if(active_obj.estado_txt==='pagado' || active_obj.estado_txt==='pendiente') {
                $('BUTTON.btn-anular').show();
            } else {
                $('BUTTON.btn-anular').hide();
            }
            
            if(active_obj.autorizacion_estado===true) {
                $('BUTTON.btn-autorizar').show();
            } else {
                $('BUTTON.btn-autorizar').hide();
            }   
        }
    }
    

    $('#min').change(function (e) {
        t_h_v.draw();
    });
    //Busqueda por Rango de Fechas DataTables - Hasta
    $('#max').change(function (e) {
        t_h_v.draw();
    });
})

function limpiar_busqueda()
{
    fecha_min.value = '';
    fecha_max.value = '';
    estados.value='';
    t_h_v.search('');
    t_h_v.ajax.reload();
}