let table_user;
const formulario = document.getElementById('formulario');
const btnAccion = document.getElementById('btnAccion');
const title = document.getElementById('title');
const id_usuario = document.getElementById('id');
const nombre = document.getElementById('nombre');
const usuario = document.getElementById('usuario');
const correo = document.getElementById('correo');
const caja = document.getElementById('caja');
const clave = document.getElementById('clave');
const confirmar = document.getElementById('confirmar');

const container_clave = document.getElementById('container-clave');
const container_confirmar = document.getElementById('container-confirmar');
document.addEventListener('DOMContentLoaded', function () {
    //DataTables usuarios - Ajax
    table_user = $('#table_user').DataTable({
        "aPreocesing": true,
        "aServerSide": false,
        "ajax": {
            "url": "" + base_url + "usuarios/listar",
            "dataSrc": ""
        },
        "columns": [{ "data": "id" },
        { "data": "usuario" },
        { "data": "correo" },
        { "data": "nombre" },
        { "data": "estado" },
        { "data": "editar" },
        { "data": "eliminar" },
        { "data": "rol" }
        ],
        "dom": "<'row'<'col-sm-4'l><'col-sm-4 text-center'B><'col-sm-4'f>>" +
            "<'row'<'col-sm-12'tr>>" +
            "<'row'<'col-sm-5'i><'col-sm-7'p>>",
        buttons,
        language,
        "resonsieve": true,
        "bDestroy": true,
        "iDisplayLength": 10,
        "order": [
            [ 0, 'desc']
        ]
    });

    var forms = document.getElementsByClassName('needs-validation');
    // Loop over them and prevent submission
    var validation = Array.prototype.filter.call(forms, function (form) {
        form.addEventListener('submit', function (event) {
            event.preventDefault();
            if (form.checkValidity() === false) {                
                event.stopPropagation();
                form.classList.add('was-validated');
            } else {
                const url = base_url + 'usuarios/registrar';
                const http = new XMLHttpRequest();
                http.open("POST", url, true);
                http.send(new FormData(formulario));
                http.onreadystatechange = function () {
                    if (this.readyState == 4 && this.status == 200) {
                        const res = JSON.parse(this.responseText);
                        alertas(res.msg, res.icono);
                        if (res.icono == 'success') {
                            $('#nuevo_usuario').modal('hide');
                            table_user.ajax.reload();
                        }
                    }
                }
            }

        }, false);
    });
})

// Function Para levantar el modal, esta function se llama en Views/usuarios/index.php
function frmUsuario() {
    id_usuario.value = '';
    title.textContent = 'Nuevo Usuario';
    btnAccion.textContent = 'Registrar';
    formulario.reset();
    container_clave.classList.remove('d-none');
    container_confirmar.classList.remove('d-none');
    confirmar.setAttribute('required', 'required');
    clave.setAttribute('required', 'required');
    $('#nuevo_usuario').modal('show');
}

function btnEditarUser(id) {
    title.textContent = 'Modificar Usuario';
    btnAccion.textContent = 'Modificar';
    const url = base_url + 'usuarios/editar/' + id;
    const http = new XMLHttpRequest();
    http.open("GET", url, true);
    http.send();
    http.onreadystatechange = function () {
        if (this.readyState == 4 && this.status == 200) {
            const res = JSON.parse(this.responseText);
            id_usuario.value = res.id;
            nombre.value = res.nombre;
            usuario.value = res.usuario;
            correo.value = res.correo;
            caja.value = res.id_caja;
            confirmar.removeAttribute('required');
            clave.removeAttribute('required');
            container_clave.classList.add('d-none');
            container_confirmar.classList.add('d-none');
            $('#nuevo_usuario').modal('show');
        }
    }

}

function btnEliminarUser(id) {
    Swal.fire({
        title: 'Esta seguro de eliminar?',
        text: "El usuario no se eliminará de forma permanente, solo cambiará el estado a inactivo!",
        icon: 'warning',
        showCancelButton: true,
        confirmButtonColor: '#3085d6',
        cancelButtonColor: '#d33',
        confirmButtonText: 'Si!',
        cancelButtonText: 'No'
    }).then((result) => {
        if (result.isConfirmed) {
            const url = base_url + "usuarios/eliminar/" + id;
            const http = new XMLHttpRequest();
            http.open("GET", url, true);
            http.send();
            http.onreadystatechange = function () {
                if (this.readyState == 4 && this.status == 200) {
                    const res = JSON.parse(this.responseText);
                    alertas(res.msg, res.icono);
                    if (res.icono == 'success') {
                        table_user.ajax.reload();
                    }
                    
                }
            }
        }
    })
}

function btnReingresarUser(id) {
    Swal.fire({
        title: 'Esta seguro de reingresar?',
        icon: 'warning',
        showCancelButton: true,
        confirmButtonColor: '#3085d6',
        cancelButtonColor: '#d33',
        confirmButtonText: 'Si!',
        cancelButtonText: 'No'
    }).then((result) => {
        if (result.isConfirmed) {
            const url = base_url + "usuarios/reingresar/" + id;
            const http = new XMLHttpRequest();
            http.open("GET", url, true);
            http.send();
            http.onreadystatechange = function () {
                if (this.readyState == 4 && this.status == 200) {
                    const res = JSON.parse(this.responseText);
                    alertas(res.msg, res.icono);
                    if (res.icono == 'success') {
                        table_user.ajax.reload();
                    }
                }
            }

        }
    })
}

//fin usuarios