<?php
class Home extends Controller
{
    public function __construct() {
        session_start();
        if (!empty($_SESSION['activo'])) {
            header("location: ".base_url. "admin");
        }
        parent::__construct();
    }
    public function index()
    {
        $data = $this->model->getVerificar('empresa');
        $this->views->getView('home', "index", $data);
    }
    public function validar()
    {
        if (empty(strClean($_POST['usuario'])) || empty(strClean($_POST['clave']))) {
            $msg = array('msg' => "El usuario y la contraseña es requerido", 'icono' => 'warning');
        } else {
            $usuario = strClean($_POST['usuario']);
            $clave = strClean($_POST['clave']);
            $data = $this->model->getUsuario($usuario);
            if ($data != null) {
                if (password_verify($clave, $data['clave'])) {
                    $_SESSION['id_usuario'] = $data['id'];
                    $_SESSION['id_caja'] = $data['id_caja'];
                    $_SESSION['usuario'] = $data['usuario'];
                    $_SESSION['tipousuario'] = $data['tipousuario'];
                    $_SESSION['nombre'] = $data['nombre'];
                    $_SESSION['activo'] = true;
                    $_SESSION['ticket'] = true;
                    $this->verificarPermisos($data['id']);
                    $msg = array('msg' => "ok");
                } else {
                    $msg = array('msg' => "Contraseña incorrecta", 'icono' => 'error');
                }
            } else {
                $msg = array('msg' => "El usuario no existe", 'icono' => 'warning');
            }
        }
        echo json_encode($msg, JSON_UNESCAPED_UNICODE);
        die();
    }

    ## PERMISOS
    public function verificarPermisos($id_usuario)
    {
        //1.- PERMISOS ADMINISTRACIÓN
        $per_admin = $this->model->verificarPermisos($id_usuario, "administracion");
        $data['admin'] = (!empty($per_admin) || $id_usuario == 1) ? true : false;
        //2.- PERMISOS USERS
        $per_users = $this->model->verificarPermisos($id_usuario, "usuarios");
        $data['usuarios'] = (!empty($per_users) || $id_usuario == 1) ? true : false;
        //3.- PERMISOS CAJAS
        $per_caja = $this->model->verificarPermisos($id_usuario, "cajas");
        $data['cajas'] = (!empty($per_caja) || $id_usuario == 1) ? true : false;
        //4.- PERMISOS ARQUEO
        $per_arqueo = $this->model->verificarPermisos($id_usuario, "arqueo caja");
        $data['arqueo'] = (!empty($per_arqueo) || $id_usuario == 1) ? true : false;
        //5.- PERMISOS MOVIMIENTO
        $per_movi = $this->model->verificarPermisos($id_usuario, "movimientos caja");
        $data['movimiento'] = (!empty($per_movi) || $id_usuario == 1) ? true : false;
        //6.- PERMISOS MEDIDAS
        $per_med = $this->model->verificarPermisos($id_usuario, "medidas");
        $data['medidas'] = (!empty($per_med) || $id_usuario == 1) ? true : false;
        //7.- PERMISOS CATEGORIAS
        $per_cat = $this->model->verificarPermisos($id_usuario, "categorias");
        $data['categorias'] = (!empty($per_cat) || $id_usuario == 1) ? true : false;
        //8.- PERMISOS MARCAS
        $per_marc = $this->model->verificarPermisos($id_usuario, "marcas");
        $data['marcas'] = (!empty($per_marc) || $id_usuario == 1) ? true : false;
        //9.- PERMISOS PRODUCTOS
        $per_pro = $this->model->verificarPermisos($id_usuario, "productos");
        $data['productos'] = (!empty($per_pro) || $id_usuario == 1) ? true : false;
        //10.- PERMISOS COTIZACIONES
        $per_cot = $this->model->verificarPermisos($id_usuario, "cotizaciones");
        $data['cotizaciones'] = (!empty($per_cot) || $id_usuario == 1) ? true : false;
        //11.- PERMISOS APARTADOS
        $per_apart = $this->model->verificarPermisos($id_usuario, "apartados");
        $data['apartados'] = (!empty($per_apart) || $id_usuario == 1) ? true : false;
        //12.- PERMISOS COMPRAS
        $per_compra = $this->model->verificarPermisos($id_usuario, "compras");
        $data['compras'] = (!empty($per_compra) || $id_usuario == 1) ? true : false;
        //13.- PERMISOS VENTAS
        $per_venta = $this->model->verificarPermisos($id_usuario, "ventas");
        $data['ventas'] = (!empty($per_venta) || $id_usuario == 1) ? true : false;
        //14.- PERMISOS CREDITO COMPRAS
        $per_cred_com = $this->model->verificarPermisos($id_usuario, "administrar creditos compras");
        $data['credito_compra'] = (!empty($per_cred_com) || $id_usuario == 1) ? true : false;
        //15.- PERMISOS CREDITO VENTAS
        $per_cred_ven = $this->model->verificarPermisos($id_usuario, "administrar creditos ventas");
        $data['credito_venta'] = (!empty($per_cred_ven) || $id_usuario == 1) ? true : false;
        //16.- PERMISOS PDF
        $per_pdf = $this->model->verificarPermisos($id_usuario, "reportes pdf");
        $data['pdf'] = (!empty($per_pdf) || $id_usuario == 1) ? true : false;
        //17.- PERMISOS EXCEL
        $per_excel = $this->model->verificarPermisos($id_usuario, "reportes excel");
        $data['excel'] = (!empty($per_excel) || $id_usuario == 1) ? true : false;
        $_SESSION['permisos'] = $data;
    }
}
