<?php
class CajasModel extends Query
{
    public function __construct()
    {
        parent::__construct();
    }
    public function getCajas()
    {
        $sql = "SELECT * FROM cajas";
        $data = $this->selectAll($sql);
        return $data;
    }
    public function registrarCaja(string $nombre)
    {
        $verficar = "SELECT * FROM cajas WHERE caja = '$nombre'";
        $existe = $this->select($verficar);
        if (empty($existe)) {
            $sql = "INSERT INTO cajas(caja) VALUES (?)";
            $datos = array($nombre);
            $data = $this->save($sql, $datos);
            if ($data == 1) {
                $res = "ok";
            } else {
                $res = "error";
            }
        } else {
            $res = "existe";
        }
        return $res;
    }
    public function modificarCaja(string $nombre, int $id)
    {
        $sql = "UPDATE cajas SET caja = ? WHERE id = ?";
        $datos = array($nombre, $id);
        $data = $this->save($sql, $datos);
        if ($data == 1) {
            $res = "modificado";
        } else {
            $res = "error";
        }
        return $res;
    }
    public function editarCaja(int $id)
    {
        $sql = "SELECT * FROM cajas WHERE id = $id";
        $data = $this->select($sql);
        return $data;
    }
    public function accionCaja(int $estado, int $id)
    {
        $sql = "UPDATE cajas SET estado = ? WHERE id = ?";
        $datos = array($estado, $id);
        $data = $this->save($sql, $datos);
        return $data;
    }
    public function cerrarAcciones(string $table, int $estado, int $id)
    {
        $sql = "UPDATE $table SET estado = ? WHERE id_usuario = ?";
        $datos = array($estado, $id);
        $data = $this->save($sql, $datos);
        return $data;
    }
    public function getApertura(string $table, int $id)
    {
        $sql = "SELECT * FROM $table WHERE id_usuario = $id";
        $data = $this->selectAll($sql);
        return $data;
    }
    public function registrarCierre(int $id_user, int $id_caja, string $fecha, string $monto)
    {
        $verficar = "SELECT * FROM cajas_cierre WHERE id_usuario = '$id_user' AND estado = 1";
        $existe = $this->select($verficar);
        if (empty($existe)) {
            $sql = "INSERT INTO cajas_cierre(id_usuario, id_caja, fecha_apertura, monto_inicial, total) VALUES (?,?,?,?,?)";
            $datos = array($id_user, $id_caja, $fecha, $monto, $monto);
            $data = $this->save($sql, $datos);
            if ($data == 1) {
                $res = "ok";
            } else {
                $res = "error";
            }
        } else {
            $res = "existe";
        }
        return $res;
    }
    public function cerrarCaja(string $fecha, string $monto, string $total, int $ventas, string $prestamos, string $devolucion, string $gastos, string $ingresos, int $id)
    {
        $sql = "UPDATE cajas_cierre SET fecha_fin=?, monto_fin=?, total=?, ventas=?, estado=?, prestamos=?, devolucion=?, gastos=?, ingresos=? WHERE id_usuario = ?";
        $datos = array($fecha, $monto, $total, $ventas, 0, $prestamos, $devolucion, $gastos, $ingresos, $id);
        $data = $this->save($sql, $datos);
        if ($data == 1) {
            $res = "ok";
        } else {
            $res = "error";
        }
        return $res;
    }
    public function apertura(string $table, int $id)
    {
        $sql = "UPDATE $table SET apertura=? WHERE id_usuario = ?";
        $datos = array(0, $id);
        $data = $this->save($sql, $datos);
        if ($data == 1) {
            $res = "ok";
        } else {
            $res = "error";
        }
        return $res;
    }
    public function verificar(string $accion, int $id)
    {
        $sql = "SELECT total, $accion(total) AS total FROM ventas WHERE id_usuario = $id AND apertura = 1";
        $data = $this->select($sql);
        return $data;
    }
    public function getCajaCierre(int $id)
    {
        $sql = "SELECT * FROM cajas_cierre WHERE id_usuario = $id AND estado = 1";
        $data = $this->select($sql);
        return $data;
    }
    public function monto_inicial(int $id)
    {
        $sql = "SELECT * FROM cajas_cierre WHERE id = $id";
        $data = $this->select($sql);
        return $data;
    }
    
    public function getTotalVentas(int $id)
    {
        $sql = "SELECT COUNT(*) AS total FROM ventas WHERE id_usuario = $id AND apertura = 1 AND estado = 1";
        $data = $this->select($sql);
        return $data;
    }
    public function getMontoFinal(int $id)
    {
        $sql = "SELECT SUM(total) AS monto_final FROM ventas WHERE id_usuario = $id AND apertura = 1 AND forma_pago = 1 AND estado = 1";
        $data = $this->select($sql);
        return $data;
    }
    public function getMontoCredito(int $id_user)
    {
        $sql = "SELECT SUM(monto) AS total FROM abonos WHERE id_usuario = $id_user AND apertura = 1";
        $data = $this->select($sql);
        return $data;
    }
    public function registrarMovimiento(string $accion, string $monto, string $desc, int $id_user, string $fecha, string $hora)
    {
        $sql_ventas = "SELECT SUM(total) AS monto_final FROM ventas WHERE id_usuario = $id_user AND apertura = 1 AND estado = 1";
        $sql_credito = "SELECT abonado, SUM(abonado) AS total FROM creditos WHERE id_usuario = $id_user";
        $sql_prest = "SELECT SUM(monto) AS total FROM prestamo_caja WHERE id_usuario = $id_user AND estado = 1";
        $sql_gasto = "SELECT SUM(monto) AS total FROM gasto_caja WHERE id_usuario = $id_user AND estado = 1";
        $sql_devolucion = "SELECT SUM(monto) AS total FROM devolucion_caja WHERE id_usuario = $id_user AND estado = 1";
        $ventas = $this->select($sql_ventas);
        $creditos = $this->select($sql_credito);
        $prestamo = $this->select($sql_prest);
        $gasto = $this->select($sql_gasto);
        $devolucion = $this->select($sql_devolucion);
        $total = ($devolucion['total'] + ($ventas['monto_final'] - ($prestamo['total'] + $gasto['total']))) + $creditos['total'];
        if ($total >= $monto) {
            $sql = "INSERT INTO $accion(monto, descripcion,id_usuario, fecha, hora) VALUES (?,?,?,?,?)";
            $datos = array($monto, $desc, $id_user, $fecha, $hora);
            $save = $this->save($sql, $datos);
            if ($save == 1) {
                $res = "ok";
            } else {
                $res = "error";
            }
        } else {
            $res = "no";
        }
        return $res;
    }

    public function registrarDevolucion(string $accion, string $monto, string $desc, int $id_user, string $fecha, string $hora)
    {
        $sql = "INSERT INTO $accion(monto, descripcion,id_usuario, fecha, hora) VALUES (?,?,?,?,?)";
        $datos = array($monto, $desc, $id_user, $fecha, $hora);
        $save = $this->save($sql, $datos);
        if ($save == 1) {
            $res = "ok";
        } else {
            $res = "error";
        }
        return $res;
    }
    public function getAcciones(string $table, int $id)
    {
        $sql = "SELECT SUM(monto) AS total FROM $table WHERE id_usuario = $id AND estado = 1";
        $data = $this->select($sql);
        return $data;
    }
    public function getEmpresa()
    {
        $sql = "SELECT * FROM empresa";
        $data = $this->select($sql);
        return $data;
    }
    public function getApartados(int $id)
    {
        $sql = "SELECT SUM(monto_abono) AS total FROM apartados WHERE id_usuario = $id AND estado = 1";
        $data = $this->select($sql);
        return $data;
    }
}
