<?php include "Views/templates/header.php"; ?>

<section class="content">
    <div class="container-fluid">
        <div class="row">
            <div class="col-md-12">

                <!-- Profile Image -->
                <div class="card card-primary card-outline">
                    <div class="card-body box-profile">
                        <div class="text-center">
                            <img class="profile-user-img img-fluid img-circle" src="<?php echo base_url . 'Assets/img/avatar.svg'; ?>" alt="User profile picture">
                        </div>

                        <h3 class="profile-username text-center"><?php echo $data['nombre']; ?></h3>

                        <p class="text-muted text-center"><?php echo $data['usuario']; ?></p>

                        <ul class="list-group list-group-unbordered mb-3">
                            <li class="list-group-item">
                                <b>Correo: </b> <a class="float-right"><?php echo $data['correo']; ?></a>
                            </li>
                            <li class="list-group-item">
                                <b>F. registro</b> <a class="float-right"><?php echo $data['fecha']; ?></a>
                            </li>
                        </ul>
                    </div>
                    <!-- /.card-body -->
                </div>
                <!-- /.card -->
            </div>
            <!-- /.col -->
            <div class="col-md-12">
                <div class="card">
                    <div class="card-header p-2">
                        <ul class="nav nav-pills">
                            <li class="nav-item"><a class="nav-link active" href="#credencial" data-toggle="tab">Password</a></li>
                            <li class="nav-item"><a class="nav-link" href="#settings" data-toggle="tab">Settings</a></li>
                        </ul>
                    </div><!-- /.card-header -->
                    <div class="card-body">
                        <div class="tab-content">
                            <div class="active tab-pane" id="credencial">
                                <form class="form-horizontal needs-validation" novalidate id="frmPass" autocomplete="off">
                                    <div class="form-group row">
                                        <label for="usuario" class="col-sm-6 col-form-label">Contraseña actual</label>
                                        <div class="col-sm-6">
                                            <input type="password" class="form-control" id="actual" name="actual" placeholder="Contraseña actual" required>
                                            <div class="valid-feedback">
                                                Correcto
                                            </div>
                                            <div class="invalid-feedback">
                                                Contraseña actual es requerido
                                            </div>
                                        </div>
                                    </div>
                                    <div class="form-group row">
                                        <label for="correo" class="col-sm-6 col-form-label">Contraseña nueva</label>
                                        <div class="col-sm-6">
                                            <input type="password" class="form-control" id="nueva" name="nueva" placeholder="Contraseña nueva" required>
                                            <div class="valid-feedback">
                                                Correcto
                                            </div>
                                            <div class="invalid-feedback">
                                                Contraseña nueva es requerido
                                            </div>
                                        </div>
                                    </div>
                                    <div class="form-group row">
                                        <label for="nombre" class="col-sm-6 col-form-label">Confirmar contraseña</label>
                                        <div class="col-sm-6">
                                            <input type="password" class="form-control" id="confirmar" name="confirmar" placeholder="Confirmar contraseña" required>
                                            <div class="valid-feedback">
                                                Correcto
                                            </div>
                                            <div class="invalid-feedback">
                                                Confirmar contraseña es requerido
                                            </div>
                                        </div>
                                    </div>
                                    <div class="form-group row">
                                        <div class="offset-sm-6 col-sm-6">
                                            <button type="submit" class="btn btn-outline-primary">Guardar</button>
                                        </div>
                                    </div>
                                </form>

                            </div>

                            <div class="tab-pane" id="settings">
                                <form class="form-horizontal needs-validation" novalidate id="frmDatos" autocomplete="off">
                                    <div class="form-group row">
                                        <label for="usuario" class="col-sm-3 col-form-label">Usuario</label>
                                        <div class="col-sm-9">
                                            <input type="text" class="form-control" id="usuario" name="usuario" value="<?php echo $data['usuario']; ?>" placeholder="Usuario" required>
                                            <div class="valid-feedback">
                                                Correcto
                                            </div>
                                            <div class="invalid-feedback">
                                                El usuario es requerido
                                            </div>
                                        </div>
                                    </div>
                                    <div class="form-group row">
                                        <label for="correo" class="col-sm-3 col-form-label">Correo</label>
                                        <div class="col-sm-9">
                                            <input type="email" class="form-control" id="correo" name="correo" value="<?php echo $data['correo']; ?>" placeholder="Correo" required>
                                            <div class="valid-feedback">
                                                Correcto
                                            </div>
                                            <div class="invalid-feedback">
                                                El correo es requerido
                                            </div>
                                        </div>
                                    </div>
                                    <div class="form-group row">
                                        <label for="nombre" class="col-sm-3 col-form-label">Nombre</label>
                                        <div class="col-sm-9">
                                            <input type="text" class="form-control" id="nombre" name="nombre" value="<?php echo $data['nombre']; ?>" placeholder="Nombre" required>
                                            <div class="valid-feedback">
                                                Correcto
                                            </div>
                                            <div class="invalid-feedback">
                                                El nombre es requerido
                                            </div>
                                        </div>
                                    </div>
                                    <div class="form-group row">
                                        <div class="offset-sm-6 col-sm-6">
                                            <button type="button" id="btnProfile" class="btn btn-outline-primary">Guardar</button>
                                        </div>
                                    </div>
                                </form>
                            </div>
                            <!-- /.tab-pane -->
                        </div>
                        <!-- /.tab-content -->
                    </div><!-- /.card-body -->
                </div>
                <!-- /.card -->
            </div>
            <!-- /.col -->
        </div>
        <!-- /.row -->
    </div><!-- /.container-fluid -->
</section>
<?php include "Views/templates/footer.php"; ?>